#!/usr/local/bin/ruby -Ku

require 'core'
include RevWiki

begin

	model = amrita_standard_model
	tmpl = nil
	
	case PARAM_COMMAND
	#----------------
	# ページ編集
	#----------------
	
	when 'edit'
		
		if $cgi.params.include?('send') then
			before_rev = $cgi['current_rev'].to_i
			before_fix = $cgi['current_fix'].to_i
	
			# 更新の衝突をチェック
			if (before_rev != $current_page.rev) || (before_fix != $current_page.fix) then
				amrita_error_message("更新の衝突", <<-ECHO)
					ページが他のユーザーによって更新されています。
					（Rev#{before_rev}.#{before_fix}→ Rev#{$current_page.rev}.#{$current_page.fix}）
				ECHO
			end
	
	
			#------------------
			# ページ内容を送信
			#------------------
			if $cgi['revision'] == 'fix' then
				$current_page.fix_edit($cgi['content'].gsub(/\r\n/, "\n"))
				amrita_reload("#{$current_page.name}を修正しました。")

			elsif $current_page.exist? then
				$current_page.edit($cgi['content'].gsub(/\r\n/, "\n"), $current_user,
				                   $cgi['summary'], $cgi['revision'] == 'minor')
	
				amrita_reload(sprintf("%sを編集しました。（Rev%d.%d → Rev%s）", $current_page.name,
				                      before_rev, before_fix, $current_page.rev_full))
			else
				$current_page = Page.make($cgi['content'].gsub(/\r\n/, "\n"), CGI.unescape(PARAM_PAGE), $current_user)
				amrita_reload("#{$current_page.name}を作成しました。（Rev1.0）")
	
			end
			
			exit(0)
		else
			#--------------
			# 編集フォーム
			#--------------
			model[:title] = $current_page.name + "の編集"
			model[:page_title] = {}
		
			if $current_page.exist? then
				# 既存のページを編集
				model[:page_title][:page_title_link] = Amrita.a(:href => view_url($current_page.name)){ $current_page.name }
				model[:page_title][:page_title_suffix] = "の編集"
				model[:content] = $current_page.load_content
				model[:minor_update] = {}
				model[:minor_update][:minor_update_check] = ""
				model[:summary] = {}
				model[:summary][:summary_field] = Amrita.a(:value => $cgi['summary'])
				model[:current_rev] =
					Amrita.a(:value => ($cgi.params.include?('current_rev') ? $cgi['current_rev'] : $current_page.rev.to_s))
				model[:current_fix] =
					Amrita.a(:value => ($cgi.params.include?('current_fix') ? $cgi['current_fix'] : $current_page.fix.to_s))
				model[:revision] = {}
				model[:revision][:revision_select] = []

				# メジャー/マイナーの選択
				model[:revision][:revision_select][0] =
					Amrita.a(:value => "major"){ sprintf("大きな更新 (Rev%d.0)", $current_page.rev + 1) }

				t = sprintf("細部の更新 (Rev%d.%d)", $current_page.rev, $current_page.fix + 1)
				if $cgi['revision'] == "minor" then
					model[:revision][:revision_select][1] =	Amrita.a(:value => "minor", :selected => "1"){ t }
				else
					model[:revision][:revision_select][1] =	Amrita.a(:value => "minor"){ t }
				end

				if $current_page.editor == $current_user.name && defined?(ENABLED_FIX) && ENABLED_FIX then
					if $cgi['revision'] == "fix" then
						model[:revision][:revision_select][2] =	Amrita.a(:value => "fix", :selected => "1"){ "修正" }
					elsif 
						model[:revision][:revision_select][2] =	Amrita.a(:value => "fix"){ "修正" }
					end
					model[:fix_caution] =
						"（「修正」を選択すると、本文・更新日時以外の情報は変化せず、概要を入力しても無視されます）"
				end
				
			else
				# 新規ページを作成
				model[:page_title] = $current_page.name + "の編集"
				model[:content] = ""
				model[:minor_update] = nil
				model[:summary] = nil
				model[:revision] = {}
				model[:revision][:revision_select] = "新規ページの作成 (Rev1.0)"
			end
	
			model[:page] = Amrita.a(:value => $current_page.name)
			model[:current_rev] = Amrita.a(:value => $current_page.rev)
			model[:current_fix] = Amrita.a(:value => $current_page.fix)
			if $current_user.prefs['required_preview'] then
				model[:send] = "" if $cgi.params.include?('preview')
			else
				model[:send] = ""
			end
		
			# プレビュー処理
			if $cgi.params.include?('preview') then
				model[:preview] = Amrita::SanitizedString.new(WikiCloth.new(UTF8String.new($cgi['content'].gsub(/\r\n/, "\n"))).content_to_html)
				model[:content] = $cgi['content']
			end
		
		
			tmpl = amrita_standard_template("edit_form.tmpl")
		end
	
	
	#----------------
	# コメント送信
	#----------------
	
	when 'comment'
			before_rev = $current_page.rev
			before_fix = $current_page.fix
	
			wiki_cloth = WikiCloth.new($current_page.load_content)\
			             .insert_comment($cgi['index'].to_i, $cgi['text'], $current_user.name)
			$current_page.edit(wiki_cloth.text, $current_user, "（コメント）", true)
	
			amrita_reload(sprintf("%sにコメントを送信しました。（Rev%d.%d → Rev%s）", $current_page.name,
				                    before_rev, before_fix, $current_page.rev_full))
	
			exit(0)
	
	
	#----------------
	# 個人設定
	#----------------
	
	when 'pref'
		prefs = $current_user.prefs
		attr_checked = Amrita.a(:checked => 'on'){''}
	
		if $cgi.params.include?('send') then
			prefs['required_preview'] = $cgi.include?('required_preview')
			prefs['enabled_create_page'] = $cgi.include?('enabled_create_page')
			prefs['enabled_rename'] = $cgi.include?('enabled_rename')
			prefs['visible_access_key'] = $cgi.include?('visible_access_key')
			prefs['invisible_side_menu'] = $cgi.include?('invisible_side_menu')
			prefs['theme'] = $cgi['theme'] if $cgi.include?('theme')
			$current_user.save
			amrita_reload("設定を変更しました。")

		elsif $cgi.params.include?('reset') then
			$current_user.prefs = DEFAULT_PREFS.dup
			$current_user.save
			amrita_reload("すべての設定項目をリセットしました。")

		else
			tmpl = amrita_standard_template("pref_form.tmpl")
			
	
			model[:page_title] = "Preferences"
			model[:preference] = Hash.new("")
			model[:preference][:required_preview] = attr_checked if prefs['required_preview']
			model[:preference][:enabled_create_page] = attr_checked if prefs['enabled_create_page']
			model[:preference][:enabled_rename] = attr_checked if prefs['enabled_rename']
			model[:preference][:visible_access_key] = attr_checked if prefs['visible_access_key']
			model[:preference][:invisible_side_menu] = attr_checked if prefs['invisible_side_menu']

			model[:preference][:theme_rows] = []
			Theme.get_themes.each do |theme|
				model[:preference][:theme_rows] << theme.to_model
				if (prefs['theme'] || DEFAULT_PREFS['theme']) == theme.dir_name then
					model[:preference][:theme_rows].last[:theme_check][:theme_check_button] = attr_checked
				end
			end

			LOG.puts Theme.get_themes.inspect
			

		end
	
	#----------
	# 一覧表示
	#----------
	
	when 'list'
		model[:page_title] = "ページ一覧"
		tmpl = amrita_standard_template($current_user.admin? ? "list_all.tmpl" : "list.tmpl")
	
		attr_checked = Amrita.a(:checked => 'on'){''}
		model[:setting] = Hash.new('')
	
	
		order = ($cgi['order'] || 'update')
		case order
		when 'update'
			model[:setting][:order_update] = attr_checked
		when 'name'
			model[:setting][:order_name] = attr_checked
		end
	
		model[:list] = {}
		model[:list][:rows] = []
		rows = model[:list][:rows]
		
		PAGE_TABLE.each_pair do |name, page|
			row_model = {}
			row_model[:number] = page.number
			row_model[:name] = name
			row_model[:name_link] = Amrita.a(:href => view_url(name)){ name }
			row_model[:update] = Amrita::SanitizedString.new(sprintf("%s (Rev%s)", time_to_html(page.update), page.rev_full))
			row_model[:editor] = page.editor || "????"
			row_model[:file_size] = sprintf("%.2f KB", page.total_file_size / 1000.0)
			row_model[:view_count] = sprintf("%d/%d", page.today_view_count, page.yesterday_view_count)
	
			row_model[:view] = {}
	
			rows << row_model
		end
	
		# ソート
		model[:sort] = {}
		model[:sort][:sort_by_name] =
			Amrita.a(:href => command_url('list', 'sort' => 'name')){"名前順"}
		model[:sort][:sort_by_update] =
			Amrita.a(:href => command_url('list', 'sort' => 'update')){"更新日時順"}
		model[:sort][:sort_by_number] =
			Amrita.a(:href => command_url('list', 'sort' => 'score')){"番号順"}
	
	
		case $cgi['sort']
		when 'update'
			model[:sort][:sort_by_update] = "【更新日時順】"
			rows.sort!{|x,y| x[:update] <=> y[:update] }
			rows.reverse!
		when 'score'
			model[:sort][:sort_by_number] = "【番号順】"
			rows.sort!{|x,y| x[:number] <=> y[:number] }
		else
			model[:sort][:sort_by_name] = "【名前順】"
			rows.sort!{|x,y| x[:name] <=> y[:name] }
		end
	
	when 'edit_history'
		model[:page_title] = "編集履歴:#{$current_user.name}"
		tmpl = amrita_standard_template("edit_history.tmpl")
	
		attr_checked = Amrita.a(:checked => 'on'){''}
		model[:setting] = Hash.new('')
	
		model[:edit_history] = {}
		model[:edit_history][:rows] = []
		rows = model[:edit_history][:rows]
		
		$current_user.edit_history.each do |item|
			row_model = {}
			row_model[:name_link] = Amrita.a(:href => view_url(item.page_name)){ item.page_name }
			row_model[:update] = Amrita::SanitizedString.new(sprintf("%s (Rev%d.%d)", time_to_html(item.update), item.rev, item.fix))
			row_model[:summary] = (item.summary || "")
	
			rows << row_model
		end
	
		# ソート
		rows.sort!{|x,y| x[:update] <=> y[:update] }
		rows.reverse!
	
	
	
		
	#----------------
	# リビジョン表示
	#----------------
	
	when 'revision'
	
		
		model[:revision] = {}
		model[:revision][:rows] = []
	
		model[:page_title] = {}
		model[:page_title][:page_title_link] = Amrita.a(:href => view_url($current_page.name)){$current_page.name}
		model[:page_title][:page_title_prefix] = "リビジョン："
	
	
	
		revisions = $current_page.revisions
		revisions << $current_page
		revisions.reverse!
	
		revisions.each do |revision|
			row_model = {}
			row_model[:select1] = {}
			row_model[:select1][:radio1] = Amrita.a(:value => revision.rev_full){''}
			row_model[:select2] = {}
			row_model[:select2][:radio2] = Amrita.a(:value => revision.rev_full){''}
			row_model[:rev] = revision.rev_full
			row_model[:update] = time_to_html(revision.update)
			row_model[:editor] = revision.editor || ""
			row_model[:summary] = revision.summary || ""
			row_model[:view] = {}
			row_model[:view][:view_link] =\
				Amrita.a(:href => "view.cgi?p=#{CGI.escape($current_page.name)}&rev=#{revision.rev}&fix=#{revision.fix}")\
				{"この版を表示"}
			row_model[:view][:diff_link] =\
				Amrita.a(:href => command_url('diff', 'page' => CGI.escape($current_page.name), 'rev' => revision.rev_full)){"直前の版と比較"}
			model[:revision][:rows] << row_model
		end
	
	
		model[:revision][:rows].first[:rev].concat("(最新版)")
		model[:revision][:rows].first[:view][:view_link] = nil
		model[:revision][:rows].last[:view][:diff_link] = nil
		model[:page] = Amrita.a(:value => PARAM_PAGE){""}
	
		model[:range] = {}
		model[:range][:range_10] =
			Amrita.a(:href => command_url('revision', 'page' => PARAM_PAGE, 'range' => 10)){"最新から10件"}
		model[:range][:range_20] =
			Amrita.a(:href => command_url('revision', 'page' => PARAM_PAGE, 'range' => 20)){"最新から20件"}
		model[:range][:range_all] =
			Amrita.a(:href => command_url('revision', 'page' => PARAM_PAGE, 'range' => 'all')){"全て表示"}
	
		range = ($cgi.params.include?('range') ? $cgi['range'].to_i : 10)
	
		case range
		when 10
			model[:range][:range_10] = "【最新から10件】"
		when 20
			model[:range][:range_20] = "【最新から20件】"
		else
			model[:range][:range_all] = "【全て表示】"
		end
	
		# rangeが設定されていたら、range件までしか表示しない
		if range > 1 then
			model[:revision][:rows] = model[:revision][:rows][0..(range - 1)]
		end
	
		tmpl = amrita_standard_template("revision.tmpl")
	
	
	when 'diff'
		if $cgi.params.include?('rev1') || $cgi.params.include?('rev2') then
			revision1_rev, revision1_fix =
				($cgi.params.include?('rev1') ? $cgi['rev1'] : $current_page.rev_full).split(".").collect{|x| x.to_i}
			revision2_rev, revision2_fix =
				($cgi.params.include?('rev2') ? $cgi['rev2'] : $current_page.rev_full).split(".").collect{|x| x.to_i}
	
		else
			revision1_rev, revision1_fix = $cgi['rev'].split(".").collect{|x| x.to_i}
			revision2_rev, revision2_fix = Revision.decliment_rev($current_page, revision1_rev, revision1_fix)
		end

		LOG.puts "revision1_rev = #{revision1_rev}"
		LOG.puts "revision1_fix = #{revision1_fix}"
		LOG.puts "revision2_rev = #{revision2_rev}"
		LOG.puts "revision2_fix = #{revision2_fix}"


		if ($current_page.rev == revision1_rev) && ($current_page.fix == revision1_fix) then
			revision1 = $current_page
		else
			revision1 = Revision.load($current_page.number, revision1_rev, revision1_fix)
		end
		
		if ($current_page.rev == revision2_rev) && ($current_page.fix == revision2_fix) then
			revision2 = $current_page
		else
			revision2 = Revision.load($current_page.number, revision2_rev, revision2_fix)
		end
	
	
		
	
		old_revision, new_revision = nil
		if revision1.update <= revision2.update then
			old_revision = revision1
			new_revision = revision2
		else
			old_revision = revision2
			new_revision = revision1
		end
	
		LOG.puts(old_revision.inspect, new_revision.inspect)
	
		seq_old = old_revision.load_content("diff sequence").gsub(/\r\n/, "\n").split("\n")
		seq_new = new_revision.load_content("diff sequence").gsub(/\r\n/, "\n").split("\n")
		changes = Diff::LCS.sdiff(seq_old, seq_new)
		lines = []
	
		tmpl = RevWiki.amrita_standard_template('diff.tmpl')
		model[:page_title] = {}
		model[:page_title][:page_title_link] = Amrita.a(:href => view_url($current_page.name)){$current_page.name}
		model[:page_title][:page_title_prefix] = "差分表示："
		model[:diff] = {}
		model[:diff][:old_revision] = Amrita::SanitizedString.new("Rev.#{old_revision.rev_full}<br>(#{time_to_str(old_revision.update)})")
		model[:diff][:new_revision] = Amrita::SanitizedString.new("Rev.#{new_revision.rev_full}<br>(#{time_to_str(new_revision.update)})")
		model[:diff][:lines] = []
	
		changes.each do |change|
			line_model = {}
	
			line_model[:old_element] = Amrita.a(:class => 'changed'){ change.old_element || '' }
			line_model[:new_element] = Amrita.a(:class => 'changed'){ change.new_element || '' }
	
			case change.action
			when '+'
				line_model[:action] = '+'
			when '-'
				line_model[:action] = '-'
			when '='
				line_model[:action] = ''
				line_model[:old_element] = change.old_element || ''
				line_model[:new_element] = change.new_element || ''
			when '!'
				line_model[:action] = '=>'
			else
				line_model[:action] = change.action
			end
			
			model[:diff][:lines] << line_model
		end
	
	
	
	
	#----------------
	# ページ新規作成
	#----------------
	
	when 'create_page'
		
		model[:page_title] = "ページの新規作成"
	
		tmpl = amrita_standard_template("create_page_form.tmpl")
	
	
	#------------------
	# ログインフォーム
	#------------------
	when 'login'
		
		model[:page_title] = "ユーザーログイン"
		tmpl = amrita_standard_template("auth_form.tmpl")
	
	
	#----------
	# ログイン
	#----------
	
	when 'auth'
		if $cgi.params.include?('login') then
			EntryUser.login($cgi['name'], $cgi['password'])
			amrita_reload("ようこそ#{$cgi['name']}さん。")
	
			
		elsif $cgi.params.include?('new_login') then
			user = EntryUser.make($cgi['name'], $cgi['password'])
			amrita_reload("新規ユーザー#{$cgi['name']}を作成しました。ようこそ#{$cgi['name']}さん。")
		end
	
	#------------
	# ログアウト
	#------------
	
	when 'logout'
		$session['user_number'] = nil
		amrita_reload("ログアウトしました。")
	
	
	#----------------
	# ページリネーム
	#----------------
	when 'rename'
		if $cgi.params.include?('new_page_name')
			page = Page.load_tag(PAGE_NUMBER_TABLE[$cgi['page']])
			page.rename($cgi['new_page_name'])
			amrita_reload("ページをリネームしました。（#{$cgi['page']} → #{$cgi['new_page_name']}）")
		else
			tmpl = amrita_standard_template("rename.tmpl")
			model[:page_title] = {}
			model[:page_title][:page_title_link] = Amrita.a(:href => view_url($current_page.name)){$current_page.name}
			model[:page_title][:page_title_prefix] = "リネーム:"
			model[:page_name] = Amrita.a(:value => $current_page.name)
		end
	
	#------------
	# ページ削除
	#------------
	
	when 'delete'
		EntryUser.admin_only {
			if $cgi.params.include?('confirm') then
				page = Page.load_tag(PAGE_NUMBER_TABLE[$cgi['page']])
				page.delete
				amrita_reload("#{$current_page.name}を削除しました。", "view.cgi")
	
			else
				tmpl = amrita_standard_template("delete.tmpl")
				model[:page_title] = {}
				model[:page_title][:page_title_link] = Amrita.a(:href => view_url($current_page.name)){$current_page.name}
				model[:page_title][:page_title_prefix] = "削除:"
				model[:page_name] = Amrita.a(:value => $current_page.name)
				model[:yes] = 
					Amrita.a(:href => command_url('delete', 'page' => CGI.escape($current_page.name), 'confirm' => "1")){"削除"}
				model[:no] = Amrita.a(:href => view_url($current_page.name)){"やめる"}
	
			end
		}


	#----------
	# 管理画面
	#----------
	
	when 'admin'
		EntryUser.admin_only {
			model[:page_title] = WIKI_NAME
			tmpl = amrita_standard_template("admin_menu.tmpl")

			model[:page_rows] = []
			pages = PAGE_TABLE.values.sort{|x, y| x.number <=> y.number}
			pages.each do |page|
				row_model = {}
				row_model[:file_name] = page.tag_file_name
				row_model[:name] = {}
				row_model[:name][:a] = {}
				row_model[:name][:a][:href] = view_url(page.name)
				row_model[:name][:a][:text] = page.name
				row_model[:rev] = page.rev_full
				row_model[:update] = Amrita::SanitizedString.new(sprintf("%s (Rev%s)", time_to_html(page.update), page.rev_full))
				row_model[:file_size] = sprintf("%.2f KB", page.total_file_size / 1000.0)
				row_model[:permission] = (page.frozen? ? "凍結" : "")
				row_model[:condition] = ""
		
				model[:page_rows] << row_model
			end


			model[:user_rows] = []
			user_numbers = USER_TABLE.values.sort{|x, y| x.number <=> y.number}
			user_numbers.each do |number|
				user = EntryUser.load(number)
				row_model = {}
				row_model[:file_name] = user.file_name
				row_model[:name] = {}
				row_model[:name][:a] = {}
				row_model[:name][:a][:href] = view_url(Page::MYPAGE_PREFIX + user.name)
				row_model[:name][:a][:text] = user.name
				row_model[:permission] = (user.admin? ? "管理者" : "登録ユーザー")
				row_model[:condition] = ""
		
				model[:user_rows] << row_model
			end

			model[:plugin_rows] = []
			PLUGINS.each do |plugin|
				row_model = {}
				row_model[:name] = plugin.dir_name
				row_model[:maker] = plugin.maker
				row_model[:summary] = plugin.summary
		
				model[:plugin_rows] << row_model
			end


			today_view_hosts = load_store(Page.record_file_path, 'today_view_hosts')
			yesterday_view_hosts = load_store(Page.record_file_path, 'yesterday_view_hosts')
			today_referers = load_store(Page.record_file_path, 'today_referers')
			yesterday_referers = load_store(Page.record_file_path, 'yesterday_referers')

			model[:access_rows] = []
			pages = PAGE_TABLE.values.sort{|x, y| x.name <=> y.name}
			pages.each do |page|
				row_model = {}
				row_model[:page_name] = page.name
				row_model[:view_count] =
					sprintf("%d/%d", page.today_view_count, page.yesterday_view_count)
				row_model[:visitor_count] =
					sprintf("%d/%d", (today_view_hosts[page.number] || []).size, (yesterday_view_hosts[page.number] || []).size)


				row_model[:today_referers] = []
				row_model[:yesterday_referers] = []

				if today_referers[page.number] then
					today_referers[page.number].each_pair do |url, count|
						referer_model = {}
						referer_model[:a] = {}
						referer_model[:a][:href] = url
						referer_model[:a][:text] = "#{url} (#{count})"
						row_model[:today_referers] << referer_model
					end
				else
					row_model[:today_referers] << ""
				end

				if yesterday_referers[page.number] then
					yesterday_referers[page.number].each_pair do |url, count|
						referer_model = {}
						referer_model[:a] = {}
						referer_model[:a][:href] = url
						referer_model[:a][:text] = "#{url} (#{count})"
						row_model[:yesterday_referers] << referer_model
					end
				else
					row_model[:yesterday_referers] << ""
				end



				model[:access_rows] << row_model
			end

		
		}


	end
	
	amrita_output(tmpl, model)




rescue StandardError, LoadError
	error_out("#{$0} でエラーが発生しました。")
end
