module RevWiki
	start_time = Time.now

	# コアバージョン表示
	CORE_VERSION = 'period5 fix1 (Experimental)'

	# CGIオブジェクト作成
	require 'cgi/session/pstore'
	$cgi = CGI.new('html4Tr')

	# セキュリティレベル指定（デフォルトで1）
	$SAFE = 1

	# エラー出力関数定義
	module_function
	def error_out(message)
		$cgi.out{
			$cgi.html{
				$cgi.head{} +
				$cgi.body{
					"<p>ERROR:#{message}</p><hr>" + 
					"<pre>  #{CGI.escapeHTML($!.message)}\r\n  #{CGI.escapeHTML($!.backtrace.join("\r\n  "))}</pre>"
				}
			}
		}
		# 念のためセッションファイルを初期化しておく
		#$session.delete
		exit
	end


	# 設定ファイル読み込み
	begin
		require 'regulation'
		include Regulation
	
		#	ディレクトリが存在しなければ作っておく
		DIR_PATHS.each_value do |path|
			unless path.exist? then
				path.mkdir
				path.chmod(DIR_PERMISSION)
			end
		end

	rescue StandardError, LoadError
		error_out("設定ファイル（regulation.*）の読み込みに失敗しました。")
	end


	# ログ初期化
	begin
		# ログクラス定義読み込み
		require((DIR_PATHS[:revwiki] + 'class_logger').to_s)
	
		# ログファイル作成
		LOG = ((LOG_RECORD || $cgi.params.include?('log')) ? Log.new : DummyLog.new)
	
		LOG.enter
		LOG.puts "LogFile Open ==========================="
		LOG.puts "RevisionistWiki #{CORE_VERSION} Starting..."
		LOG.puts "Date : #{Time.now.strftime('%y-%m-%d %a. %H:%d:%S')}"
		LOG.puts "Ruby-Core : #{RUBY_VERSION} (#{RUBY_PLATFORM})"
		LOG.enter
		LOG.indent
	
		at_exit{
			# プロセスタイム出力
			LOG.puts "Process Time:"
			LOG.indent

			if defined?(PROCESS_TIME) then
				PROCESS_TIME.each_pair do |name, time|
					LOG.puts sprintf("%s - %f sec", name, time)
				end
			end
			

			LOG.indent_level = 0
			LOG.puts "LogFile Close ==========================="
			LOG.enter
			LOG.close

			# 暫定的にこの場所に置く
			FILE_PATHS[:lock].delete if FILE_PATHS[:lock].exist?
		}
	
	
		# ログファイルにregulationの中身を記録
		LOG.puts("Regulation:")
		LOG.indent_level += 1
	
		Regulation.constants.each do |cst_name|
			LOG.puts sprintf("%s: %s", cst_name, RevWiki.module_eval("Regulation::#{cst_name}.inspect"))
		end
	
		LOG.indent_level -= 1
		LOG.enter

	rescue StandardError, LoadError
		error_out("動作ログの初期化に失敗しました。")
		LOG.close if defined?(LOG)
	end




	# 各種ライブラリ読み込み
	begin
		$LOAD_PATH.unshift(DIR_PATHS[:lib])
		require 'diff/lcs'
		require 'kconv'
		require 'uconv'
		require 'timeout'
		require 'amrita/template'
		require 'htmlsplit'
		require 'cgisup'
	rescue LoadError, StandardError
		error_out("#{DIR_PATHS[:lib]} ディレクトリからのライブラリの読み込みに失敗しました。")
	end

	# セッションファイル作成
	begin
		options = {}
		options['tmpdir'] = Dir.tmpdir
		options['database_manager'] = CGI::Session::PStore
		LOG.puts "tmpdir = #{Dir.tmpdir}"
		$session = CGI::Session.new($cgi, options)
		LOG.event_log("Session initialized", nil, 
		              "Message" => $session['message'],
		              "Prefs" => $session['prefs'].inspect)
	rescue StandardError
		error_out("セッションの初期化に失敗しました。")
	end


	# 言語ファイル読み込み
	begin
		$LOAD_PATH.unshift(DIR_PATHS[:language] + "ja")
		require 'interface'
		include Interface
	rescue LoadError, StandardError
		error_out("言語ファイルの読み込みに失敗しました。")
	end


	# RevWikiライブラリ読み込み
	begin
		$LOAD_PATH.unshift(DIR_PATHS[:revwiki])
		require 'function'
		require 'class_page_level2'
		require 'class_page_level1'
		require 'class_user_level2'
		require 'class_user_level1'
		require 'class_descript'
		require 'htmlscanner'
		require 'class_error'
		require 'menu'
		require 'parameter_check'
		require 'translator_interface'
		require 'amrita_interface'
		require 'theme_interface'
		require 'plugin_interface'
		require 'jcode'
		require 'profiler'
	rescue LoadError, StandardError
		error_out("#{DIR_PATHS[:revwiki]} ディレクトリからのライブラリの読み込みに失敗しました。")
	end



	COMMANDS_WITHOUT_PAGE = ['list', 'create_page', 'login', 'auth', 'edit_history', 'pref']

	# 各種キャッシュテーブル作成
	begin
		RevWiki.instant_profile("caching"){
			# 念のため番号0番のページを削除（存在するとエラーが出るため）
			path = DIR_PATHS[:data] + number_to_file_name(0, 'tag')
			path.delete if path.exist?
	
			PAGE_NUMBER_TABLE = Page.get_number_table
			PAGE_TABLE = Page.get_page_table
			USER_TABLE = EntryUser.get_user_number_table
			KEYWORD_TABLE = []
			PAGE_TABLE.each_key do |page_name|
				KEYWORD_TABLE << $1 if page_name =~ Page::KEYWORD_PREFIX_PATTERN
			end
			LOG.puts "UserTable: #{USER_TABLE.inspect} (#{USER_TABLE.class.to_s})"
		}
	rescue StandardError
		error_out("キャッシュテーブルの作成に失敗しました。")
	end


	# $current_userセット
	begin
		if $session['user_number'] then
			$current_user = EntryUser.load($session['user_number'].to_i, "session login")
		else
			$current_user = AnonymousUser.new
		end
	
		LOG.puts "$current_user: #{$current_user.inspect}"

		# メニューから
		prefs = $current_user.prefs
		WIKI_MENU_ITEMS.delete(MENU_WORDS[:create_page]) unless prefs['enabled_create_page']
		PAGE_MENU_ITEMS.delete(MENU_WORDS[:renanme]) unless prefs['enabled_rename']
	
		# メニューにマイページの項目を追加
		mypage_name = Page::MYPAGE_PREFIX + $current_user.name
		WIKI_MENU_ITEMS.push(MenuItem.new(view_url(mypage_name), $current_user.name, "マイページ", false, USER_ONLY))

	rescue StandardError
		error_out("ユーザー設定に失敗しました。")
	end


	# パラメータ解釈
	begin
		if $cgi.params.include?('page') then
			PARAM_PAGE = $cgi['page']
	
		elsif $cgi.params.include?('p') then
			PARAM_PAGE = $cgi['p']
	
		elsif $cgi.query_string && ($cgi.query_string != "") && ($cgi.query_string !~ /\=/) then
			PARAM_PAGE = $cgi.query_string
	
		else
			PARAM_PAGE = PAGE_NAMES[:front_page]
	
		end
	
		page_name = Page.filt_name(CGI.unescape(PARAM_PAGE))
		LOG.puts "Page Name: #{page_name}"

		if $cgi.params.include?('cmd') then
			PARAM_COMMAND = $cgi['cmd']
		elsif $cgi.params.include?('c') then
			PARAM_COMMAND = $cgi['c']
		else
			PARAM_COMMAND = nil
		end


	rescue StandardError
		error_out("パラメータの解釈に失敗しました。")
	end



	begin
		if (page_name =~ Page::SPECIAL_PREFIX_PATTERN) || (COMMANDS_WITHOUT_PAGE.include?(PARAM_COMMAND)) then
			$current_page = SpecialPage.new
			$current_page.name = page_name
		else
			check_page_name(page_name)
		
			if PAGE_NUMBER_TABLE.include?(page_name) then
				$current_page = Page.load_tag(PAGE_NUMBER_TABLE[page_name], "initialize")
			else
				$current_page = Page.new(0)
				$current_page.name = page_name
			end
		end
	
		LOG.puts "Page: #{$current_page.inspect}"
	rescue StandardError
		error_out("ページ設定に失敗しました。")
	end

	begin
		PLUGINS = Plugin.load_all
		PLUGIN_UNIT = PluginUnit.new

	rescue StandardError, LoadError
		error_out("プラグインのロードに失敗しました。")
	end




	# その他
	begin
		# 編集モード/閲覧モード
		if $cgi.params.include?('edit_mode') then
			$edit_mode = !($cgi['edit_mode'] == '0')
			$session['edit_mode'] = $edit_mode
		else
			$edit_mode = ($session['edit_mode'] == nil ? true : $session['edit_mode'])
		end
	
		# メッセージセット
		if $session['message'] && !( $session['message'] == "" ) then
			MESSAGE = $session['message']
			$session['message'] = nil
		elsif $session['redirect_from'] && !( $session['redirect_from'] == "" ) then
			MESSAGE = sprintf(%Q|（<a href="%s">%s</a> からリダイレクト）|,
			                  view_url($session['redirect_from'], 'no_redirect' => "1"),
			                  CGI.escapeHTML($session['redirect_from']))
			$session['redirect_from'] = nil

		else
			MESSAGE = ""
		end

		# Blogモード
		#if BLOG_MODE then
		#	unless $current_user.admin?
		#		$edit_mode = false 
		#		WIKI_MENU_ITEMS.delete!(MENU_WORDS[:edit_mode])
		#	end
		#end

	rescue StandardError, LoadError
		error_out("#{$0} でエラーが発生しました。")
	end

	LOG.puts "core.rb all sequence #{Time.now - start_time} sec."

end

