# Ruby CGI Adjuster Library
# Copyright (c) 2002-2005 HORIKAWA Hisashi. All rights reserved.
# You can redistribute this software and/or modify it under the Ruby's License.
#     mailto:vzw00011@nifty.ne.jp
#     http://www.nslabs.jp/

require "cgi/session"
require "digest/md5"
require "time"

class CGI
  module QueryExtension
  if $COMPAT_VERSION && $COMPAT_VERSION < '1.8.0'
    def [](key)
      return @params[key]
    end
  elsif RUBY_VERSION == '1.8.1' || RUBY_VERSION == '1.8.2'
    def [](key)
      value = @params[key].first
      if @multipart
        if value
          return value
        elsif defined?(StringIO)
          StringIO.new("")
        else
          Tempfile.new("CGI")
        end
      else
        return value || ""
      end
    end
  end

    def file_control(key)
      io, = @params[key]
      if !io
        return nil
      elsif !defined?(io.read)
        raise RuntimeError, "The enctype attribute must be 'multipart/form-data.'"
      else
        return io
      end
    end

    # @return control value or default value.
    def get(key, default = "")
      value = @params[key].first
          # コントロールkeyが存在しないときは、enctypeに関わらず valueはnilになる。
      if defined?(value.read)
        return value.read
      else
        return value || default
      end
    end
  end
end

