
require "test/unit/testcase"
require "test/unit/ui/console/testrunner"

require "htmlsplit"

class StructureTest < Test::Unit::TestCase
  # 
  def test11
    html = "<!--  <foo> & <bar> -->"
    o = HTMLSplit.new(html)
    assert_equal("  <foo> & <bar> ", o.document[0].text)
  end

  # ʥȡWeb֥饦Ǥϡ"-->"ޤǥȤˤʤ롣
  def test12
    html = "<!-- foo -- bar -->"
    o = HTMLSplit.new(html)
    assert_equal(" foo -- bar ", o.document[0].text)
  end

  # ̿ (PI)
  def test21
    html = "<?hoge <foo> & <bar> ?>"
    o = HTMLSplit.new(html)
    assert_instance_of(PHP, o.document[0])
    assert_equal("hoge <foo> & <bar> ", o.document[0].text)   # PITargetǧʤ
  end

=begin
  # CDATA
  def test31
  end
=end

  # ʸ
  def test41
    html = '<!DOCTYPE greeting SYSTEM "hello.dtd">'
    o = HTMLSplit.new(html)
    assert_instance_of(Declaration, o.document[0])
    assert_equal('DOCTYPE greeting SYSTEM "hello.dtd"', o.document[0].text)
  end

=begin
  # ֥å
  def test42
    html = '<!DOCTYPE greeting [ <!ELEMENT greeting (#PCDATA)> ]>'
    o = HTMLSplit.new(html)
    assert_instance_of(Declaration, o.document[0])
    assert_equal('DOCTYPE greeting SYSTEM "hello.dtd"', o.document[0].text)
  end
=end

  # ϥ
  def test51
    html = "<foo bar='hoge'>"    # '...'ǰϤǤ褤
    o = HTMLSplit.new(html)
    tag = o.document[0]
    assert_instance_of(StartTag, tag)
    assert_equal({"bar" => "hoge"}, tag.attr)
  end

  # ǥ (XML)
  # empty_tagsˤʤȤStartTag֤
  #       HTMLʥץꥱˤXMLƤʤ
  def test52
    html = "<foo/>"
    o = HTMLSplit.new(html)
    tag = o.document[0]
    assert_instance_of(StartTag, tag)
    assert_equal({"/" => true}, tag.attr)
  end

  # ʥ
  def test53
    html = "<0> < <>"
    o = HTMLSplit.new(html)
    assert_instance_of(CharacterData, o.document[0])
    assert_equal("<0> ", o.document[0].text)
    assert_instance_of(CharacterData, o.document[1])
    assert_equal("< ", o.document[1].text)
    assert_instance_of(CharacterData, o.document[2])
    assert_equal("<>", o.document[2].text)
  end

  # λ
  def test54
    html = "</foo>"
    o = HTMLSplit.new(html)
    tag = o.document[0]
    assert_instance_of(EndTag, tag)
    assert_equal("foo", tag.name)
  end

  # SGMLǤϡ°ͤ켰ΤȤϡ°̾άǤ롣
  # °̾ά줿ϡ°=>true֤
  def test55
    html = "<foo bar>"
    o = HTMLSplit.new(html)
    tag = o.document[0]
    assert_instance_of(StartTag, tag)
    assert_equal({"bar" => true}, tag.attr)
    assert_equal("<foo bar>", tag.to_s)
  end

  # Ĥʤϥ     SGMLǵꡣWeb֥饦ǤᤷƤ
  def test61
    html = "<foo<bar>"
    o = HTMLSplit.new(html)
    tag = o.document[0]
    assert_instance_of(StartTag, tag)
    assert_equal("foo", tag.name)
    tag = o.document[1]
    assert_instance_of(StartTag, tag)
    assert_equal("bar", tag.name)
  end

  # Ĥʤλ    SGMLǵꡣWeb֥饦ǤᤷƤ
  def test62
    html = "</foo</bar>"
    o = HTMLSplit.new(html)
    tag = o.document[0]
    assert_instance_of(EndTag, tag)
    assert_equal("foo", tag.name)
    tag = o.document[1]
    assert_instance_of(EndTag, tag)
    assert_equal("bar", tag.name)
  end

  # ǥȽꤹ륿̾ɲá
  def test71
    html = "<x:foo>"
    o = HTMLSplit.new()
    o.empty_tags << "x:foo"
    o.set_html(html)
    tag = o.document[0]

    assert_instance_of(EmptyElementTag, tag)
    assert_equal("x:foo", tag.name)
  end
end

Test::Unit::UI::Console::TestRunner.new(StructureTest).start()
