module Image
	def inline_image(*args)
		return inline_img(args)
	end

	def inline_img(*args)
		args.flatten!
		url = args.pop
		img = HTMLScanner::Element.new(nil, nil, "img", "border" => 0, "src" => url)
		element = img

		until args.empty? do
			case args.shift
			when "-link", "-l"
				element = HTMLScanner::Element.new(nil, nil, "a", "href" => args.shift)
				element.children << img
			when "-alt", "-a"
				img.attributes["alt"] = args.shift
			when "-width", "-w"
				img.attributes["width"] = args.shift.to_i
			when "-height", "-h"
				img.attributes["height"] = args.shift.to_i
			end
		end

		return element.to_html
	end

end

include Image

