

def block_ls(*args)
	args.flatten!
	root = HTMLScanner::Element.new(nil, nil, "ul", "class" => "ls")
	pages = PAGE_TABLE.values
	unless (args.empty?) || (args.last =~ /^\-/) then
		pattern = Regexp.escape(args.pop)
	else
		pattern = '\*'
	end
	pattern.gsub!(/\\\*/, ".*")
	pattern.gsub!(/\\\?/, ".?")
	pages = pages.find_all{|page| page.name =~ Regexp.new(pattern)}

	# sortオプション
	if args.include?("-name-sort") || args.include?("-ns") then
		pages.sort!{|x, y| x.name <=> y.name}
	elsif args.include?("-view-sort") || args.include?("-vs") then
		RevWiki.operate_store(Page.record_file_path){|db|
			pages.sort!{|x, y| db['today_view_counts'][x.number].to_i <=> db['today_view_counts'][y.number].to_i}
		}
	else
		pages.sort!{|x, y| x.update <=> y.update}.reverse!
	end

	# reverseオプション
	pages.reverse! if args.include?("-reverse") || args.include?("-r")

	if args.find{|x| x =~ /^\-n(\d+)/} then
		rest_number = $1.to_i
	else
		rest_number = 100
	end

	
	pages.each do |page|
		li = HTMLScanner::Element.new(root, nil, "li")
		a = HTMLScanner::Element.new(li, nil, "a", "href" => view_url(page.name))
		HTMLScanner::Text.new(a, nil, page.name)

		if args.include?("-time") || args.include?("-t")
			HTMLScanner::Text.new(li, nil, " - #{RevWiki.time_to_str(page.update)}")
		end

		rest_number -= 1
		break if rest_number <= 0
	end

	return root.to_html

end


def block_list(*args)
	return block_ls(args)
end