def block_outline
	output_tree = nil

	total_profile("outline analyzing"){
		# HTMLツリー生成
		text = ($cgi.params.include?('preview') ? $cgi['content'] : $current_page.load_content)
		html_root = HTMLScanner.get_tree(WikiCloth.new(text).remove_plugin("outline").content_to_html)
	
		# HTML解析
		headers = []
		Outline.each_header(html_root) do |h, level|
			headers << {:level => level, :text => HTMLScanner.get_text(h)}
			h.attributes["id"] = "#header_#{headers.size - 1}"
		end

		# アウトラインHTML生成
		output_tree = HTMLScanner::Element.new(nil, nil, "div", "class" => "outline")
		top_ul = HTMLScanner::Element.new(output_tree, nil, "ul")
		index = 0

		headers.each do |header|
			ul = top_ul
			ul = HTMLScanner::Element.new(ul, nil, "ul") if header[:level] >= 3
			ul = HTMLScanner::Element.new(ul, nil, "ul") if header[:level] >= 4
			li = HTMLScanner::Element.new(ul, nil, "li")

			a = HTMLScanner::Element.new(li, nil, "a", "href" => view_url($current_page.name) + "#header_#{index}")
			HTMLScanner::Text.new(a, nil, header[:text])

			index += 1
		end
	}

	return CGI.pretty(output_tree.to_html)
end



add_content_proc do |html|
	output_tree = nil
	root = nil

	total_profile("outline analyzing"){
		# HTMLツリー生成
		root = HTMLScanner.get_tree(html)
	
		# IDを振る
		index = 0
		Outline.each_header(root) do |h, level|
			h.attributes["id"] = "header_#{index}"
			index += 1
		end

	}

	root.to_html
end



module Outline
	# 再帰的に見出しタグを探す
	def Outline.each_header(parent_node, &block)
		parent_node.children.each do |child|
			if child.is_a?(HTMLScanner::Element)
				if child.name =~ /^h([2-6])$/ then
					block.call(child, $1.to_i)
				else
					each_header(child, &block)
				end
			else
				next
			end
		end
	
	end

end

=begin

def _outline_header_search_seq_in_h(parent_node, headers, header_text)
	parent_node.children.each do |child|
		case child
		when HTMLScanner::Element
			_outline_header_search_seq_in_h(child, headers, header_text)
		when HTMLScanner::Text
			header_text << child.content
		end
	end
end

=end