require 'date'

def block_recent(*args)
	args.flatten!
	pages = PAGE_TABLE.values

	# 日付範囲
	if args.find{|x| x =~ /^(\d+)/} then
		day_range = $1.to_i
	else
		day_range = 7
	end
	LOG.puts "day_range = #{day_range}"

	time = Time.now
	current_date = Date.new(time.year, time.month, time.day)
	recently_updated_pages = {}

	# 範囲内にあるページを抽出
	pages.each do |page|
		update = Date.new(page.update.year, page.update.month, page.update.day)
		LOG.puts "  #{page.name} : #{update.to_s}"
		LOG.puts "  dif = #{(current_date - update).to_i}"

		if (current_date - update).to_i < day_range then
			recently_updated_pages[update.to_s] ||= []
			recently_updated_pages[update.to_s] << page
		end
	end

	LOG.puts recently_updated_pages.inspect

	# HTML生成
	div = HTMLScanner::Element.new(nil, nil, "div", "class" => "recent")

	recently_updated_pages = recently_updated_pages.to_a
	recently_updated_pages.sort!{|x, y| x[0] <=> y[0]}.reverse!
	recently_updated_pages.each do |update_str, pages|
		h = HTMLScanner::Element.new(div, nil, "h4")
		HTMLScanner::Text.new(h, nil, update_str)
		ul = HTMLScanner::Element.new(div, nil, "ul")
		pages.sort!{|x, y| x.update <=> y.update}.reverse!
		pages.each do |page|
			li = HTMLScanner::Element.new(ul, nil, "li")
			a = HTMLScanner::Element.new(li, nil, "a", "href" => view_url(page.name))
			HTMLScanner::Text.new(a, nil, page.name)
		end
	end
	
	return div.to_html
end

def block_recently(*args)
	block_recent(args)
end