module RevWiki
	module_function

	# Amritaを用いて出力
	def amrita_output(template, model, option_headers = {})
		headers = {}
		#headers['nph'] = true
		headers['type'] = 'text/html'
		headers['charset'] = 'utf-8'

		# option_headersの内容は、HTMLのメタタグにも記載される
		# option_headers['Last-Modified'] = CGI.rfc1123_date($current_page.update) if $current_page.update
		option_headers['Pragma'] = 'no-cache'
		option_headers['Cache-Control'] = 'no-cache'
		model[:meta] = []
		option_headers.each_pair do |header, content|
			model[:meta] = {}
			model[:meta][:equiv] = header
			model[:meta][:content] = content
		end

		option_headers.each_pair do |key, value|
			headers[key.to_s] = value
		end



		# 出力	
		$cgi.out(headers){
			html_buffer = ""

			instant_profile("amrita expanding"){
				template.expand(html_buffer, model)
			}

#			# HTML整形シーケンス
#			result = ""
#			plain_mode = false
#			indent_level = 0
#			plain_tag_names = %w(plaintext pre textarea)
#
#			HTMLSplit.new(html_buffer).document.each do |token|
#				if plain_mode then
#					result << token.to_s
#					plain_mode = false if token.is_a?(EndTag) && plain_tag_names.include?(token.name)
#				else
#
#					token_str = token.to_s
#					# タブ、改行を削除（文字データなら空白も削除）
#					token_str.delete!("\t\r\n")
#					# 意味のない出力はスキップ
#					next if token_str == ""
#
#
#					# 終了タグならインデントレベル+1
#					indent_level -= 1 if token.is_a?(EndTag)
#
#					# 出力
#					result << "\t" * indent_level << token_str << "\n"
#
#					# 開始タグならインデントレベル+1
#					indent_level += 1 if token.is_a?(StartTag)
#
#
#					# 特定の開始タグならplainモード
#					plain_mode = true if token.is_a?(StartTag) && plain_tag_names.include?(token.name)
#
#				end
#			end

			# アンカーの空白を圧縮
			html_buffer.gsub!(/\<a(.*?)\>[ \r\n\t]*(.+?)[ \r\n\t]*\<\/a\>/) do |matched|
				"<a#{$1}>#{$2}</a>"
			end

			# 出力
			html_buffer
		}

		exit
	end


	# Amritaモデルを生成
	def amrita_standard_model
		model = {}
		model[:stylesheet] = {}
		model[:stylesheet][:href] =
			DIR_PATHS[:theme] + ($current_user.prefs['theme'] || DEFAULT_PREFS['theme']) + "wiki.css"
			#"./theme/blue_pipe/blue_pipe.css"
		model[:title] = WIKI_NAME
		model[:core_version] = CORE_VERSION
		model[:ruby_version] = RUBY_VERSION
		model[:master] = WIKI_MASTER
		model[:base] = {}
		model[:base][:href] = URLS[:base]
		model[:wiki_name] = WIKI_NAME


		# WWWC Meta Check
		info = sprintf("%s (Rev%s)", time_to_short_str($current_page.update), $current_page.rev_full)
		model[:wwwc_meta] = {}
		model[:wwwc_meta][:content] = info unless $current_page.number == 0

		unless $current_page.is_a?(SpecialPage) then
			model[:wwwc] = {}
			model[:wwwc][:href] = wwwc_url($current_page.name)
			model[:wwwc][:wwwc_image] = {}
			model[:wwwc][:wwwc_image][:src] = DIR_PATHS[:image] + "wwwc_meta.png"
		else
			model[:wwwc] = {}
			model[:wwwc][:wwwc_image] = Amrita.a(:style => "visibility : hidden;"){""}
		end

		
		model[:navigation] = [
			Amrita.a(:rel => 'contents', :href => 'view.cgi'),
			Amrita.a(:rel => 'index', :href => command_url('list')),
		#	Amrita.a(:rel => 'contents', :href => 'list.rb'),
		#	Amrita.a(:rel => 'search', :href => 'search.rb'),
		#	Amrita.a(:rel => 'help', :href => view_url(PAGE_NAMES[:help]))
		]


		model[:wiki_menu] = []
		WIKI_MENU_ITEMS.each do |item|
			model[:wiki_menu] << {}
			model[:wiki_menu].last[:wiki_menu_item]	= item.to_model(:wiki_menu_item_caption)
			model[:wiki_menu].last[:wiki_menu_separator]	= ""
		end
		model[:wiki_menu].last[:wiki_menu_separator] = nil

		model[:page_menu] = []
		PAGE_MENU_ITEMS.each do |item|
			model[:page_menu] << {}
			model[:page_menu].last[:page_menu_item]	= item.to_model(:page_menu_item_caption)
			model[:page_menu].last[:page_menu_separator]	= ""
		end
		model[:page_menu].last[:page_menu_separator] = nil


		model[:message] = Amrita::SanitizedString.new(MESSAGE)


		model[:ruby_image] = Amrita.a(:src => DIR_PATHS[:image] + "made_with_ruby.gif")
		model[:utf8_image] = Amrita.a(:src => DIR_PATHS[:image] + "utf8.png")

		
		# サイドメニュー表示処理
		if PAGE_TABLE.include?(PAGE_NAMES[:side_menu]) && !($current_user.prefs['invisible_side_menu']) then
			page = PAGE_TABLE[PAGE_NAMES[:side_menu]]
			model[:side_menu] = Amrita::SanitizedString.new(WikiCloth.new(page.load_content).content_to_html)
		else
			model[:invisible_side_menu_style] = Amrita::SanitizedString.new("<!-- div.main{ margin-left : 1em }	-->")
		end

		# プラグインコールバック
		model[:meta_callback] = Amrita::SanitizedString.new(PLUGIN_UNIT.meta_callback)
		model[:style_callback] = Amrita::SanitizedString.new("<!--" + PLUGIN_UNIT.style_callback + "-->")
		model[:title_callback] = Amrita::SanitizedString.new(PLUGIN_UNIT.title_callback)
		model[:footer_callback] = Amrita::SanitizedString.new(PLUGIN_UNIT.footer_callback)
		return model
	end
	
	def amrita_standard_template(tmpl_path)
		file_lock {
			text = ""
			text.concat open(DIR_PATHS[:template] + "head.tmpl", 'r'){|f| f.read}
			text.concat open(DIR_PATHS[:template] + tmpl_path, 'r'){|f| f.read}
			text.concat open(DIR_PATHS[:template] + "foot.tmpl", 'r'){|f| f.read}
			text.gsub!(/\#\{(.*)\}/) do
				Interface.module_eval $1
			end
			return Amrita::TemplateText.new(text)
		}
	end



	# ファイルを使わない、シンプルテキストテンプレート
	def amrita_simple_template(content)
		file_lock {
			tmpl = ""
			tmpl.concat open(DIR_PATHS[:template] + "head.tmpl", 'r'){|f| f.read}
			tmpl.concat Amrita::SanitizedString.new(content)
			tmpl.concat open(DIR_PATHS[:template] + "foot.tmpl", 'r'){|f| f.read}
			return Amrita::TemplateText.new(tmpl)
		}
		
	end

	def amrita_reload(message = "")
		amrita_redirect(view_url($current_page.name), message)
	end

	def amrita_redirect(location, message = "")
		$session['message'] = message
		tmpl_str = $cgi.html{ $cgi.head{} + $cgi.body{ $cgi.a(location){ "Click Here!" } } }
		tmpl = Amrita::TemplateText.new(tmpl_str)

		model = {}

		headers = {}
		headers['status'] = '303 See Other'
		headers['Location'] = location

		amrita_output(tmpl, model, headers)
	end

	def amrita_redirect_page(page_name)
		$session['redirect_from'] = $current_page.name
		tmpl_str = $cgi.html{ $cgi.head{} + $cgi.body{ $cgi.a(view_url(page_name)){ "Click Here!" } } }
		tmpl = Amrita::TemplateText.new(tmpl_str)

		model = {}

		headers = {}
		headers['status'] = '303 See Other'
		headers['Location'] = view_url(page_name)

		amrita_output(tmpl, model, headers)
	end







	def amrita_error_message(title, message)
		tmpl = amrita_simple_template(message)
		model = amrita_standard_model
		model[:title] = "エラー：#{title}"
		model[:page_title] = "エラー：#{title}"

		amrita_output(tmpl, model)
		exit
	end



end
