module RevWiki	
	class Descript
		COMMENT_PATTERN = /^\#/
		ENTRY_PATTERN = /^(.+)[ \t]*\:[ \t]*(.+)$/
		
		attr_accessor :entries

		# t@CǂݏobN͂Ȃ
		def initialize(file_path)
			@entries = {}
			if file_path.exist? then
				open(file_path, 'r') {|file|
					file.each_line do |line|
						next if line =~ COMMENT_PATTERN
						
						if line =~ ENTRY_PATTERN then
							@entries[$1.downcase] = $2
						end
					end
				}
			end

			case @entries['charset']
			when /^[sS]/
				@entries.each_pair do |key, value|
					@entries[key] = Uconv.sjistou8(value)
				end
			when /^[eE]/
				@entries.each_pair do |key, value|
					@entries[key] = Uconv.euctou8(value)
				end
			end
			
			return self
		end

		def [](entry_name)
			return(@entries[entry_name.to_s] || "-")
		end
	end
	
end
