module RevWiki
	class Log
		include RevWiki::Regulation
		INDENT = "\t"

		attr_reader :file
		attr_accessor :indent_level


		def initialize
			@file_path = DIR_PATHS[:log] + sprintf("%s_%s.log", FILE_PREFIX, Time.now.strftime("%y%m%d"))
			@file = open(@file_path, 'a')
			@indent_level = 0
		end

		def write(output)
			@file.write(output)
		end

		# putsで直接書き出し
		def puts(*output)
			if output.is_a?(String) then
				output = [output]
			end

			output.each do |str|
				str = (INDENT * @indent_level) + str
				@file.puts(str)
			end
		end

		def event_log(event_name, message = nil, parameters = {})
			self.puts(message ? "#{event_name} (#{message})" : event_name)
			@indent_level += 1

			parameters.each_pair do |key, value|
				self.puts "#{key}: #{value}"
			end
			@indent_level -= 1
		end

		def indent
			@indent_level += 1
		end

		def unindent
			@indent_level -= 1
		end


		# 改行
		def enter
			@file.puts ""
		end

		# ログファイルをクローズ
		def close
			@file.close
		end
	end

	# ダミーログ
	class DummyLog < Log
		def write(*arg); end
		def puts(*arg); end
		def enter(*arg); end
		def close(*arg); end
		def file(*arg); end
		def indent(*arg); end
		def deindent(*arg); end

		def indent_level(*arg)
			return 0
		end

		def indent_level=(*arg)
			return 0
		end
		def event_log(*arg); end

	end
end