module RevWiki
	class Page < PageProtoType


		# 編集処理を行う
		def edit(content, editor, summary, fixed = false)
			LOG.puts "Edit Sequence Start"
			LOG.indent_level += 1
			LOG.puts "Editor: #{editor.inspect}"

			content.gsub!(/\r\n/, "\n")

			revision = Revision.new(@number, self)
			
			seq1 = self.load_content.split("\n")
			seq2 = content.split("\n")
			patch = Diff::LCS.diff(seq1, seq2)
			revision.save(patch)


			# タグ情報（更新日時、概要など）を変更してセーブ
			@editor = editor.name
			@summary = summary
			if fixed then
				@fix += 1
			else
				@rev += 1; @fix = 0
				@major_update = Time.now
			end
			@update = Time.now
			self.save_tag("edit")

			self.save_content(content, "edit")


			# 編集履歴
			if editor.entry? then
				LOG.puts "Edit History Saving.."
				editor.edit_history << EditHistoryItem.new(self)
				editor.save
			end

			LOG.indent_level -= 1
			LOG.puts "Edit Sequence Finish"
		end

		# 修正処理を行う（編集とは違い、リビジョンを更新しない）
		def fix_edit(content)
			rev, fix = Revision.decliment_rev(@number, @rev, @fix)
			prev_revision = Revision.load(@number, rev, fix)
			
			seq1 = prev_revision.load_content.split("\n")
			seq2 = content.split("\n")
			patch = Diff::LCS.diff(seq1, seq2)
			prev_revision.save(patch)

			content.gsub!(/\r\n/, "\n")

			# 更新日時のみを変更してセーブ
			@update = Time.now
			self.save_tag("fix")

			self.save_content(content, "fix")

		end


		def rename(new_name)
			# 全ユーザーの編集履歴を更新
			USER_TABLE.each_pair do |name, number|
				user = EntryUser.load(number, "Rename Sequence")
				for i in 0...(user.edit_history.size)
					user.edit_history[i].page_name = new_name if user.edit_history[i].page_name == @name
				end
				user.save
			end

			# 実処理
			@name = new_name
			self.save_tag
		end

		def delete
			self.content_file_path.delete
			self.tag_file_path.delete
			self.revisions.each do |revision|
				revision.file_path.delete
			end
		end




		# ページ名から番号を得る
		# 指定したページがない場合には、nilを返す
		def Page.name_to_number(page_name, page_number_table = PAGE_NUMBER_TABLE)
			return page_number_table[page_name]
		end

		# 新しいPageオブジェクトを作成する
		# （番号も自動的に割り振る）
		def Page.make(content, name, editor)
			new_number = 1
			while (DIR_PATHS[:data] + RevWiki.number_to_file_name(new_number, "tag")).exist? do
				new_number += 1
			end

			page = Page.new(new_number)
			page.name = name
			page.editor = editor.name
			page.update = Time.now
			page.summary = "（作成）"
			page.save_content(content)
			page.save_tag("make new page")

			# 編集履歴
			if editor.entry? then
				LOG.puts "Edit History Saving.."
				editor.edit_history << EditHistoryItem.new(page)
				editor.save
			end


			return page
		end


		
	end


	class Revision < PageProtoType
	end
end
