module RevWiki
	class EntryUser
		def EntryUser.login(name, password)
			LOG.event_log("Login Sequence", nil, "name" => name.class, "UserTable" => USER_TABLE.inspect, "userTable[name]" => USER_TABLE[name])
			
			unless USER_TABLE.include?(name) then
				amrita_error_message("認証失敗", "ユーザー「#{name}」は存在しません。")
			end

			user = EntryUser.load(USER_TABLE[name])

			# パスワードが一致しなかったとき
			unless user.password_match?($cgi['password']) then
				amrita_error_message("認証失敗", "パスワードが違います。")
			end

			# ログイン成功処理
			$session['user_number'] = USER_TABLE[name]

			return user
		end

		def EntryUser.make(name, password)
			# パスワードが一致しなかったとき
			unless $cgi['password'] == $cgi['password_again']
				amrita_error_message("パスワード不一致", "一度目の入力と二度目の入力が異なっています。")
			end
	
			# ユーザー名正当性チェック
			check_page_name($cgi['name'])
	
			# パスワードの長さをチェック
			unless 4..12 === $cgi['password'].to_s.size then
				LOG.puts "password size over (#{$cgi['password'].to_s})"
				amrita_error_message("不正パスワード", "パスワード名の長さは半角4文字～12文字です。")
			end

			# 新しい番号を振る
			new_number = 1
			while (DIR_PATHS[:data] + sprintf("user_%04d.tag", new_number)).exist? do
				new_number += 1
				raise(RevWikiError) if new_number == 0 # 0になったら異常終了
			end

			user = EntryUser.new(new_number, $cgi['password'])
			user.name = name
			user.prefs = $session['prefs'] if $session['prefs']
			$session['user_number'] = new_number
			user.save

			return user
		end

		# ユーザーが管理権限を持っているときのみ、与えられたブロックを実行
		def EntryUser.admin_only
			if $current_user.admin? then
				yield
			else
				amrita_error_message("アクセス拒否", "この機能は管理権限を持っていないと使用できません。")
			end
		end


	end
end