

module RevWiki
	module_function

	# 番号からファイル名を弾き出す
	def number_to_file_name(number, ext, rev = nil)
		if rev then
			return sprintf("#{FILE_PREFIX}_%05d_rev%d.%s", number, rev, ext)
		else
			return sprintf("#{FILE_PREFIX}_%05d.%s", number, ext)
		end
	end


	VIEW_CGI_PATH = Pathname.new("view.cgi")
	COMMAND_CGI_PATH = Pathname.new("command.cgi")
	WWWC_CGI_PATH = Pathname.new("wwwc.cgi")


	def view_url(page_name, options = {})
		if options.empty? then
			href = "#{VIEW_CGI_PATH}?#{CGI.escape(Page.filt_name(page_name))}"
		else
			href = "#{VIEW_CGI_PATH}?page=#{CGI.escape(Page.filt_name(page_name))}"
			options.each_pair do |key, value|
				href << "&#{key}=#{value}"
			end
		end

		return href
	end

	def edit_url(page_name)
		return "#{COMMAND_CGI_PATH}?cmd=edit&page=#{CGI.escape(Page.filt_name(page_name))}"
	end

	def wwwc_url(page_name)
		return "#{WWWC_CGI_PATH}?#{CGI.escape(Page.filt_name(page_name))}"
	end


	def command_url(command, parameters = {})
		href = sprintf("%s?cmd=%s", COMMAND_CGI_PATH, command)
		parameters.each_pair do |key, value|
			href.concat("&#{key}=#{value}")
		end

		return href
	end



	def editable?(page = $current_page)
		# ユーザーページは編集不可

		if page.name =~ Page::MYPAGE_PREFIX_PATTERN then
			if !($current_user.entry?) || !($current_user.name == $1) then
				return false
			end
		end

		# 特殊ページは編集不可
		if page.name =~ Page::SPECIAL_PREFIX_PATTERN then
			return false
		end


		# 凍結しているページは編集不可
		if page.frozen then
			return false
		end

		# 特定のコマンドが呼ばれた場合は編集不可
		if COMMANDS_WITHOUT_PAGE.include?(PARAM_COMMAND)
			return false
		end

		# オールクリア
		return true
	end

	# timeをRevWiki式に整形した文字列を返す
	def time_to_str(time)
		return(time ? time.strftime("%y-%m-%d %a. %H:%d:%S") : "time unknown")
	end

	def time_to_html(time)
		return(time ? Amrita::SanitizedString.new(time.strftime("%y-%m-%d %a.<br />%H:%d:%S")) : "time unknown")
	end


	def time_to_short_str(time)
		return(time ? time.strftime("%y/%m/%d %H:%d") : "time unknown")
	end


	# データファイルからオブジェクトを読み込む
	def load_store(file_path, root)
		value = nil
		file_lock{
			PStore.new(file_path.to_s.untaint).transaction{|db|
					value = db[root]
			}
		}

		return value
	end

	# データファイルにオブジェクトを書き出す
	def save_store(file_path, root, value)
		file_lock{
			PStore.new(file_path.to_s).transaction{|db|
				db[root] = value
			}
		}
	end

	# データファイルを開いて何らかの操作を行う
	def operate_store(file_path)
		file_lock{
			PStore.new(file_path.to_s).transaction{|db|
				yield(db)
			}
		}

	end


	TIMEOUT_SEC = 30
	def file_lock
	  begin
			# ロックがかかっている間はループ
			timeout(TIMEOUT_SEC) do
				while FILE_PATHS[:lock].exist? do
					sleep(0.5)
				end
			end
			

			# ロックが解除されていれば、ロックファイルを作成してブロック実行
			open(FILE_PATHS[:lock], 'w'){|file|
				file.puts('locked...')
			}
			yield
		ensure
			# 後始末（ロック解除）
			FILE_PATHS[:lock].delete
		end
	end

end