# 文字コード関連のあれこれをまとめた関数
# 入れ子になっていて美しくない。スマートな方法を模索中

class String
	def to_utf8
		RevWiki.to_utf8(self)
	end

	def to_sjis
		RevWiki.to_sjis(self)
	end
end

class UTF8String < String
end

class SJisString < String
end

module RevWiki
	module_function

	def to_utf8(str)
		#UTF8Stringクラスに属していれば何もしない
		return str if str.is_a?(UTF8String)

		#SjisStringクラスに属していれば決め撃ち変換
		return UTF8String.new(Uconv.sjistou8(str)) if str.is_a?(SJisString)

	  begin
			# SHIFT-JISと仮定
	    str = Uconv.sjistou8(str)
			
			LOG.puts "(Encode string SHIFT-JIS => UTF-8)"
	  rescue Uconv::Error
			begin
				# EUC-JPと仮定
	    	str = Uconv.euctou8(str)
				LOG.puts "(Encode string EUC-JP => UTF-8)"
			rescue Uconv::Error
				# そのどれでもなかった
				str = str.toutf8 if defined?(Kconv::toutf8) # NKFが利用できるならする
				LOG.puts "(Encode string ??? => UTF-8)"
			end
	  end
	  return UTF8String.new(str)

	end

	def to_sjis(str)
	  begin
			# UTF-8と仮定
	    str = Uconv.sjistou8(str)
			LOG.puts "(Encode string UTF-8 => SHIFT-JIS)"
	  rescue Uconv::Error
			# 失敗したらNKFを使う
			str = str.to_sjis
			LOG.puts "(Encode string ??? => SHIFT-JIS)"
	  end
	  return str
	end
end