module RevWiki

	class Plugin
		include Regulation

		SCRIPT_FILE_NAME = "core.rb"
		MANUAL_FILE_NAME = "manual.txt"

		attr_reader :dir_name
		attr_reader :descript

		def initialize(dir_name, descript)
			@dir_name = (dir_name.is_a?(Pathname) ? dir_name.basename.to_s : dir_name.to_s)
			@descript = descript
		end

		def charset
			return @descript['charset']
		end


		def maker
			return @descript['maker']
		end

		def summary
			return @descript['summary']
		end

		def name
			return dir_name
		end

		def script_file_path
			return(DIR_PATHS[:plugin] + @dir_name + SCRIPT_FILE_NAME)
		end

		def manual_file_path
			return(DIR_PATHS[:plugin] + @dir_name + MANUAL_FILE_NAME)
		end



		# SẴvOC[hiԂlPluginIuWFNg̔zj
		def Plugin.load_all
			LOG.puts "Plugin Loading.."
			LOG.indent
			start_time = Time.now

			plugins = []

			RevWiki.file_lock{
				# SẴfBNgǂݍ݁APluginIuWFNg쐬
				DIR_PATHS[:plugin].children.each do |path|
					LOG.puts "Plugin found #{path}"
					next unless File.directory?(path.to_s.untaint)
	
					script_path = Pathname.new((path + SCRIPT_FILE_NAME).to_s.untaint)
					descript_path = Pathname.new((path + "descript.txt").to_s.untaint)

					if File.exist?(script_path) then
						descript = Descript.new(descript_path)
						plugins << Plugin.new(path, descript)
					end
				end


				# vOC
				plugins.each do |plugin|
					PluginUnit.class_eval(open(plugin.script_file_path.to_s.untaint, 'r'){|f| f.read}.untaint,
					                         (DIR_PATHS[:plugin] + plugin.dir_name).to_s)
				end
				$KCODE = "u"
				
			}
			LOG.unindent
			LOG.puts "Plugin OK."
			LOG.puts PluginUnit.instance_methods.join(" / ")
			LOG.puts "#{Time.now - start_time} sec"


			return plugins
		end
	end

	class PluginUnit
		include Regulation

		META_PROCS = []
		STYLE_PROCS = []
		TITLE_PROCS = []
		CONTENT_PROCS = []
		EACH_HEADER_PROCS = []
		FOOTER_PROCS = []


		def initialize

			script = <<-SCRIPT
				@cgi = $cgi
				@plugins = PLUGINS.map{|x| x.name}.freeze
				@plugin_names = @plugins
				@dir_path = Regulation::DIR_PATHS[:plugin].to_s.freeze
				@current_page_name = $current_page.name.dup.freeze
				@current_page_content = $current_page.load_content.gsub(/\r\n/, "\n").freeze
				@page_names = PAGE_TABLE.keys
			SCRIPT

			self.instance_eval(script)
			PluginUnit.instance_eval(script)

			
		end

		#------------------------------------------------
		# R[obNo^\bh (PLUGIN/1.1 Callback)
		#------------------------------------------------
		def PluginUnit.add_meta_proc(&response)
			META_PROCS << response
		end

		def PluginUnit.add_style_proc(&response)
			STYLE_PROCS << response
		end

		def PluginUnit.add_title_proc(&response)
			TITLE_PROCS << response
		end

		def PluginUnit.add_content_proc(&response)
			CONTENT_PROCS << response
		end

		#def PluginUnit.add_each_header_proc(&response)
		#	EACH_HEADER_PROCS << response
		#end

		def PluginUnit.add_footer_proc(&response)
			FOOTER_PROCS << response
		end


		#------------------------------------
		# R[obN (PLUGIN/1.1 Callback)
		#------------------------------------
		public
		def meta_callback
			return _callback(META_PROCS)
		end

		def style_callback
			return _callback(STYLE_PROCS)
		end


		def title_callback
			return _callback(TITLE_PROCS)
		end

		def content_callback(html)
			CONTENT_PROCS.each do |proc|
				html = proc.call(html)
			end
			return html
		end


		#def each_header_callback
		#	return _callback(EACH_HEADER_PROCS)
		#end

		def footer_callback
			return _callback(FOOTER_PROCS)
		end



		private
		def _callback(response_procs)
			result = ""
			response_procs.each do |proc|
				result << proc.call
			end
			return result
		end

		#--------------------------------------------
		# j[ڒǉ\bh (PLUGIN/1.3 Menu)
		#--------------------------------------------

		def PluginUnit.add_wiki_menu_item(command, caption, tip, *options)
			url = "plugin.cgi?cmd=#{command.to_s}&page="
			WIKI_MENU_ITEMS << RevWiki::MenuItem.new(url, caption, tip, true, options)
		end

		def PluginUnit.add_page_menu_item(command, caption, tip, *options)
			url = "plugin.cgi?cmd=#{command.to_s}&page="
			PAGE_MENU_ITEMS << RevWiki::MenuItem.new(url, caption, tip, true, options)
		end

	end

end
