module RevWiki
	class Theme
		CSS_NAME = "wiki.css"
		attr_reader :dir_name
		attr_accessor :name
		attr_accessor :maker
		attr_accessor :summary


		def initialize(dir_name, name = "", maker = "", summary = "")
			@dir_name = (dir_name.is_a?(Pathname) ? dir_name.basename.to_s : dir_name.to_s)
			@name = name
			@maker = maker
			@summary = summary
		end

		def file_path
			return(DIR_PATHS[:theme] + @dir_name + CSS_NAME)
		end

		def to_model
			model = {}
			model[:theme_check] = {}
			model[:theme_check][:theme_check_button] = {}
			model[:theme_check][:theme_check_button][:value] = @dir_name

			model[:theme_name] = self.name
			model[:theme_maker] = self.maker
			model[:theme_summary] = self.summary
			return model
		end


		# テーマ名のリストを取得
		def Theme.get_themes
			themes = []

			RevWiki.file_lock{
				DIR_PATHS[:theme].children.each do |path|
					next unless path.directory?
	
					if (path + CSS_NAME).exist? then
						LOG.puts "Theme found #{path}"
						descript = Descript.new(path + "descript.txt")
						themes << Theme.new(path, descript['name'], descript['maker'], descript['summary'])
					end
				end
			}

			return themes
		end
	end

	class TDiaryTheme < Theme

		def initialize(dir_name)
			super(dir_name)
			@name = @dir_name
		end

		def file_path
			return(DIR_PATHS[:theme] + @dir_name + (@dir_name + ".css"))
		end



		# テーマ名のリストを取得
		def TDiaryTheme.get_themes
			themes = []


			RevWiki.file_lock{
				DIR_PATHS[:theme].children.each do |path|
					next unless path.directory?
	
					if (path + (path.basename.to_s + ".css")).exist? then
						LOG.puts "TDiaryTheme found #{path}"
						themes << TDiaryTheme.new(path, descript['name'], descript['maker'], descript['summary'])
					end
				end
			}

			return themes
		end

	end
end
