module RevWiki


	# translator.rbの内容を評価
	file_lock{
		$LOAD_PATH.unshift(DIR_PATHS[:translator])
		RevWiki.module_eval(open(DIR_PATHS[:translator] + "translator.rb", 'r'){|f| f.read}.untaint, "translator")
	}


	class WikiCloth
		include RevWiki::Regulation

		def WikiCloth.get_page_link(caption, page_name, id = nil)
			page_name = Page.filt_name(page_name)
			url = view_url(page_name)
			url << "#" << id.to_s if id

			if PAGE_TABLE.include?(page_name) or
			page_name =~ Page::SPECIAL_PREFIX_PATTERN or
			page_name =~ Page::EDIT_PREFIX_PATTERN then
				return %Q|<a class="to_page" href="#{url}">#{caption}</a>|
			else
				return %Q|<a class="to_emptypage" href="#{url}">#{caption}</a>|
			end
		end

		private

		def eval_block_plugin(plugin_name, *args)
			args.flatten!

			begin
				argument_str = args.map{|x| "\"#{x}\""}.join(', ')
				if PLUGIN_UNIT.methods.include?("block_#{plugin_name}") then
					LOG.puts "PLUGIN_UNIT.block_#{plugin_name}(#{argument_str})"
					return eval("PLUGIN_UNIT.block_#{plugin_name}(#{argument_str})")
				else
					return sprintf("{{%s %s}}", plugin_name, args.join(" "))
				end
			rescue ArgumentError
				return "** 引数が正しくありません **<br>"

			end

		end

		def eval_inline_plugin(plugin_name, *args)
			args.flatten!
			begin
				argument_str = args.map{|x| "\"#{x}\""}.join(', ')
				LOG.puts "PLUGIN_UNIT.inline_#{plugin_name}(#{argument_str})"
				return eval("PLUGIN_UNIT.inline_#{plugin_name}(#{argument_str})")
			rescue NameError
				return "** この個所に無効なプラグイン指定（#{plugin_name}）があります **<br>"
			rescue ArgumentError
				return "** 引数が正しくありません **<br>"

			end

		end


		def transform_keywords(html)
			root = nil
			total_profile("transform keyword"){
				root = HTMLScanner.get_tree(html)
				keyword_search_seq(root)
			}
			return root.to_html
		end

		def keyword_search_seq(parent_node)
			parent_node.children.each do |child|

				# 特定のタグを見つけたら、子要素を探索せず次のトークンへ
				# そうでなければ子要素を探索
				if child.is_a?(HTMLScanner::Element) then
					case child.name.downcase
					when "a", "plaintext", "pre", "textarea"
						next
					else
						keyword_search_seq(child)
					end

				elsif child.is_a?(HTMLScanner::Text) then
					KEYWORD_TABLE.each do |keyword|
						child.content.gsub!(/#{Regexp.escape(keyword)}/) do
							WikiCloth.get_page_link(keyword, Page::KEYWORD_PREFIX + keyword)
						end
					end
				end
			end

		end
		

	end




end
