#!/usr/local/bin/ruby -Ku

require 'core'
include RevWiki


# 本文を整形ルールに従って解釈し、HTMLに変換
# さらにコールバックを通した後に返す
def parse_content_seq(content)
	html = WikiCloth.new(content).content_to_html
	# PLUGIN/1.1 Callback
	html = Amrita::SanitizedString.new(PLUGIN_UNIT.content_callback(html))

	return html
end


begin
	#--------------------
	# 特殊ページ名に一致
  #--------------------



	case $current_page.name
	when Page::EDIT_PREFIX_PATTERN
		# 編集:*
		headers = {}
		headers['status'] = '303 See Other'
		headers['Location'] = edit_url($1)
		
		tmpl = RevWiki.amrita_simple_template(<<-HTML)
			<a href="#{edit_url($1)}">編集する</a>
		HTML
		model = RevWiki.amrita_standard_model
	
		amrita_output(tmpl, model, headers)

	when Page::SPECIAL_NAMES[:plugin]
		# 特殊:プラグイン一覧
	
		tmpl = amrita_standard_template("special_plugin.tmpl")
		model = amrita_standard_model
		page_name = Page::SPECIAL_NAMES[:plugin]

		model[:title] = "#{page_name} - #{WIKI_NAME}"
		model[:page_title] = {}
		model[:page_title][:page_title_link] =
			Amrita.a(:href => view_url(page_name)){page_name}

		model[:outline_items] = []
		model[:plugins] = []
		

		PLUGINS.each do |plugin|
			li_model = {}
			li_model[:a] = {}
			li_model[:a][:href] = view_url(page_name) + "#" + plugin.dir_name
			li_model[:a][:text] = "#{plugin.dir_name} （#{plugin.summary}）"
			model[:outline_items] << li_model

			plugin_model = {}
			plugin_model[:header] = {}
			plugin_model[:header][:a] = {}
			plugin_model[:header][:a][:name] = plugin.dir_name
			plugin_model[:header][:a][:text] = li_model[:a][:text].dup
			plugin_model[:content] = open(plugin.manual_file_path, 'r'){|f| f.read}
			model[:plugins] << plugin_model
		end
	
		amrita_output(tmpl, model)


	when Page::SPECIAL_NAMES[:format_help]
		# 特殊:整形ルール
		def $current_page.content_file_path
			return(DIR_PATHS[:translator] + "format_help.wiki")
		end
	
		tmpl = amrita_standard_template("view.tmpl")
		model = amrita_standard_model
		model[:title] = sprintf"#{Page::SPECIAL_NAMES[:format_help]} - #{WIKI_NAME}"
		model[:page_title] = {}
		model[:page_title][:page_title_link] =
			Amrita.a(:href => view_url(Page::SPECIAL_NAMES[:format_help])){Page::SPECIAL_NAMES[:format_help]}
		model[:page_title][:sub_title] = "(#{FORMAT_NAME})"
	
		

		model[:content] = parse_content_seq($current_page.load_content)
	
		amrita_output(tmpl, model)


	when Page::SPECIAL_NAMES[:keyword]
		# 特殊:キーワード

		tmpl = amrita_standard_template("special_keyword.tmpl")
		model = amrita_standard_model
		model[:title] = sprintf"#{Page::SPECIAL_NAMES[:keyword]} - #{WIKI_NAME}"
		model[:page_title] = {}
		model[:page_title][:page_title_link] =
			Amrita.a(:href => view_url(Page::SPECIAL_NAMES[:keyword])){Page::SPECIAL_NAMES[:keyword]}
	
		model[:keywords] = []
		KEYWORD_TABLE.each do |keyword|
			model[:keywords] << {}
			model[:keywords].last[:keyword_link] =
				Amrita.a(:href => view_url(Page::KEYWORD_PREFIX + keyword), :class => "to_page"){ keyword }
		end
	
		amrita_output(tmpl, model)

	end

	#------------------------------
	# 特殊ページ名に一致しなかった
  #------------------------------
	if $current_page.exist? then
		tmpl = amrita_standard_template("view.tmpl")
		model = amrita_standard_model
	
	
		if $cgi.params.include?('rev') || $cgi.params.include?('fix') then
			# リビジョン指定
			rev = $cgi['rev'].to_i
			fix = $cgi['fix'].to_i
	
			revision = Revision.load($current_page.number, rev, fix)
			unless revision then
				amrita_error_message("無効なリビジョン指定", "指定されたリビジョンが見つかりません。")
			end
	
			model[:title] = "#{$current_page.name} - #{WIKI_NAME}"
			model[:page_title] = {}
			model[:page_title][:page_title_link] = Amrita.a(:href => view_url($current_page.name)){$current_page.name}
			model[:page_title][:sub_title] = "(Rev#{rev}.#{fix})"
	
			model[:content] = parse_content_seq(revision.load_content)

		else
			# ページが存在する場合、そのページを表示
			$current_page.on_viewed
			
			model[:title] = "#{$current_page.name} - #{WIKI_NAME}"
			model[:page_title] = {}
			model[:page_title][:page_title_link] = Amrita.a(:href => view_url($current_page.name)){$current_page.name}

			content = $current_page.load_content
			wiki_cloth = WikiCloth.new(content)
			if wiki_cloth.redirecting_page_name && !($cgi.params.include?('no_redirect')) then
				amrita_redirect_page(Page.filt_name(wiki_cloth.redirecting_page_name))
			else
			# ページ本文
				model[:content] = parse_content_seq(content)

			end
		end
	
		amrita_output(tmpl, model)
	
	
	else
		# ページが存在しない場合は編集フォームにリダイレクト
		headers = {}
		headers['status'] = '303 See Other'
		headers['Location'] = edit_url($current_page.name)
		
		tmpl = RevWiki.amrita_simple_template(<<-HTML)
			ページ「#{$current_page.name}」は存在しません。→<a href="#{RevWiki.edit_url($current_page.name)}">編集する</a>
		HTML
		model = RevWiki.amrita_standard_model
		model[:page_title] = "エラー"

		$session['message'] = MESSAGE
	
		amrita_output(tmpl, model, headers)
	end

rescue StandardError, LoadError
	error_out("#{$0} でエラーが発生しました。")
end
