#!/usr/local/bin/ruby -Ku

require 'core'
include RevWiki


begin
	headers = {}
	headers[:charset] = 'euc-jp'

	content = Uconv.u8toeuc(sprintf("Rev%s: %s", $current_page.rev_full, $current_page.summary))

	$cgi.out{
		$cgi.html{
			$cgi.head{
				Uconv.u8toeuc(%Q|<title>#{$current_page.name} - #{WIKI_NAME}</title>\n|) +
				%Q|<META NAME="WWWC" CONTENT="#{content}">\n| +
				%Q|<meta name="robots" content="noindex,nofollow">\n|
			} +
			$cgi.body{
				Uconv.u8toeuc(<<-ECHO)
					<p style="font-size : small; line-height : 1.2em; text-align : center;">
						<a href="#{wwwc_url($current_page.name)}">#{URLS[:base] + wwwc_url($current_page.name)}</a><br>
						このURLをWWWCに登録すると、#{$current_page.name}の更新概要を確認できます。<br>
						（プロパティの「METAタグを使ったチェックを行う」の項目にチェックを入れてください）<br>
            <a href="#{view_url($current_page.name)}">戻る</a></p>
						<p style="text-align : center">
							<a href="http://www.nakka.com/wwwc/"><img src="http://www.nakka.com/wwwc/wwwc_meta.png" width="88" height="31" alt="WWWC META Check" border="0"></a>
						</p>

					</p>
				ECHO
			}
		}
	}
rescue StandardError, LoadError
	error_out("#{$0} でエラーが発生しました。")
end
